/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.block;

import com.yuushya.block.YuushyaBlockFactory;
import com.yuushya.block.blockstate.YuushyaBlockStates;
import com.yuushya.registries.YuushyaRegistryData;
import com.yuushya.utils.YuushyaUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class CableBlock
extends YuushyaBlockFactory.BlockWithClassType {
    public CableBlock(BlockBehaviour.Properties properties, Integer tipLines, String classType, String autoCollision, YuushyaRegistryData.Block.Usage usage) {
        super(properties, tipLines, classType, autoCollision, usage);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{BlockStateProperties.f_61374_, YuushyaBlockStates.ISEND, YuushyaBlockStates.DISTANCE});
    }

    public static BlockState updateDistanceFromPost(BlockState state, LevelAccessor world, BlockPos pos) {
        Direction direction = Direction.NORTH;
        int fromNW = 0;
        int fromSE = 0;
        Direction facingDirection = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        switch (facingDirection.m_122434_()) {
            case Z: {
                BlockState nblockstate = YuushyaUtils.getBlockState(world.m_8055_(pos.m_122012_()), world, pos.m_122012_());
                BlockState sblockstate = YuushyaUtils.getBlockState(world.m_8055_(pos.m_122019_()), world, pos.m_122019_());
                Direction ndirection = nblockstate.m_60734_() instanceof CableBlock ? (Direction)nblockstate.m_61143_((Property)BlockStateProperties.f_61374_) : (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
                Direction sdirection = sblockstate.m_60734_() instanceof CableBlock ? (Direction)sblockstate.m_61143_((Property)BlockStateProperties.f_61374_) : (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
                fromNW = CableBlock.getDistanceFromPost(nblockstate, state);
                fromSE = CableBlock.getDistanceFromPost(sblockstate, state);
                if (CableBlock.isCablePostBlock(nblockstate)) {
                    direction = Direction.NORTH;
                    break;
                }
                if (CableBlock.isCablePostBlock(sblockstate)) {
                    direction = Direction.SOUTH;
                    break;
                }
                direction = fromNW < fromSE ? ndirection : sdirection;
                break;
            }
            case X: {
                BlockState wblockstate = YuushyaUtils.getBlockState(world.m_8055_(pos.m_122024_()), world, pos.m_122024_());
                BlockState eblockstate = YuushyaUtils.getBlockState(world.m_8055_(pos.m_122029_()), world, pos.m_122029_());
                Direction wdirection = wblockstate.m_60734_() instanceof CableBlock ? (Direction)wblockstate.m_61143_((Property)BlockStateProperties.f_61374_) : (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
                Direction edirection = eblockstate.m_60734_() instanceof CableBlock ? (Direction)eblockstate.m_61143_((Property)BlockStateProperties.f_61374_) : (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
                fromNW = CableBlock.getDistanceFromPost(wblockstate, state);
                fromSE = CableBlock.getDistanceFromPost(eblockstate, state);
                direction = CableBlock.isCablePostBlock(wblockstate) ? Direction.WEST : (CableBlock.isCablePostBlock(eblockstate) ? Direction.EAST : (fromNW < fromSE ? wdirection : edirection));
            }
        }
        int distance = Math.min(fromNW, fromSE);
        boolean isend = fromNW == fromSE || Math.abs(fromNW - fromSE) == 1;
        return (BlockState)((BlockState)((BlockState)state.m_61124_((Property)YuushyaBlockStates.DISTANCE, (Comparable)Integer.valueOf(distance))).m_61124_((Property)YuushyaBlockStates.ISEND, (Comparable)Boolean.valueOf(isend))).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)direction);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isCablePostBlock(BlockState blockState) {
        Block block = blockState.m_60734_();
        if (!(block instanceof YuushyaBlockFactory.BlockWithClassType)) return false;
        YuushyaBlockFactory.BlockWithClassType block2 = (YuushyaBlockFactory.BlockWithClassType)block;
        if (!block2.classType.equals("CablePostBlock")) return false;
        return true;
    }

    public static int getDistanceFromPost(BlockState blockState, BlockState thisState) {
        if (CableBlock.isCablePostBlock(blockState)) {
            return 0;
        }
        if (blockState.m_60734_() instanceof CableBlock && YuushyaBlockFactory.isTheSameLine(blockState, thisState)) {
            return Math.min((Integer)blockState.m_61143_((Property)YuushyaBlockStates.DISTANCE) + 1, 15);
        }
        return 15;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        BlockState res = blockPlaceContext.m_43719_().m_122434_() == Direction.Axis.Y ? (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)blockPlaceContext.m_8125_()) : (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)blockPlaceContext.m_43719_().m_122424_());
        return CableBlock.updateDistanceFromPost(res, (LevelAccessor)blockPlaceContext.m_43725_(), blockPlaceContext.m_8083_());
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return CableBlock.updateDistanceFromPost(stateIn, worldIn, currentPos);
    }
}

